package data.scripts.weapons;

import com.fs.starfarer.api.AnimationAPI;
import com.fs.starfarer.api.GameState;
import com.fs.starfarer.api.Global;
import com.fs.starfarer.api.combat.CombatEngineAPI;
import com.fs.starfarer.api.combat.EveryFrameWeaponEffectPlugin;
import com.fs.starfarer.api.combat.ShipAPI;
import com.fs.starfarer.api.combat.WeaponAPI;
import com.fs.starfarer.api.util.Misc;
import java.awt.Color;

public class NeutRingEveryFrameEffect implements EveryFrameWeaponEffectPlugin {

    private final float idleFPS = 10f;
    private final float activeFPS = 16f;
    private final float froceVentFPSMult = 2f;
    private final float deltaFPS = 2f;
    private final Color phaseColor = new Color(255, 175, 255, 255);

    private final String id = "Ring";
    private final float ringVentRange = 0.4f;

    @Override
    public void advance(float amount, CombatEngineAPI engine, WeaponAPI weapon) {

        ShipAPI ship = weapon.getShip();
        // flux part
        float fluxLevel = ship.getFluxTracker().getFluxLevel();
        float overFluxRatio = 0;
        if (ship.isPhased() && fluxLevel > 1 - ringVentRange) {
            overFluxRatio = (fluxLevel + ringVentRange - 1) / ringVentRange;
            float phaseCostRatio = 1 - 2 * overFluxRatio;
            ship.getMutableStats().getPhaseCloakUpkeepCostBonus().modifyMult(id, phaseCostRatio);
            float moveSlowRatio = Math.max(1 - overFluxRatio, 0.05f);
            ship.getMutableStats().getAcceleration().modifyMult(id, moveSlowRatio);
            ship.getMutableStats().getDeceleration().modifyMult(id, moveSlowRatio);
            ship.getMutableStats().getMaxSpeed().modifyMult(id, moveSlowRatio);
            ship.getMutableStats().getTurnAcceleration().modifyMult(id, moveSlowRatio);
            ship.getMutableStats().getMaxTurnRate().modifyMult(id, moveSlowRatio);
        } else {
            ship.getMutableStats().getPhaseCloakUpkeepCostBonus().unmodifyMult(id);
            ship.getMutableStats().getAcceleration().unmodifyMult(id);
            ship.getMutableStats().getDeceleration().unmodifyMult(id);
            ship.getMutableStats().getMaxSpeed().unmodifyMult(id);
            ship.getMutableStats().getTurnAcceleration().unmodifyMult(id);
            ship.getMutableStats().getMaxTurnRate().unmodifyMult(id);
        }
        // Animation part
        AnimationAPI anime = weapon.getAnimation();
        float currentFPS = anime.getFrameRate();
        Color color = Misc.interpolateColor(Color.WHITE, phaseColor, ship.getPhaseCloak().getEffectLevel());
        if (ship.isHulk()) {
            if (currentFPS > 0) {
                float setFPS = currentFPS - deltaFPS * amount;
                if (setFPS < 0) {
                    setFPS = 0;
                }
                anime.setFrameRate(setFPS);
                weapon.getSprite().setColor(color);
            } else {
                return;
            }
        } else if (ship.getPhaseCloak().isActive() && currentFPS < activeFPS * (overFluxRatio * froceVentFPSMult)) {
            float setFPS = currentFPS + deltaFPS * amount;
            if (setFPS > activeFPS * (overFluxRatio * froceVentFPSMult)) {
                setFPS = activeFPS * (overFluxRatio * froceVentFPSMult);
            }
            anime.setFrameRate(setFPS);
            weapon.getSprite().setColor(color);
            ShipAPI playerShip = Global.getCombatEngine().getPlayerShip();
            if (Global.getCurrentState() == GameState.COMBAT && playerShip != null && !playerShip.isHulk() && playerShip == ship) {
                Global.getCombatEngine().maintainStatusForPlayerShip(id+1,
                        "graphics/neut/icons/hullsys/neutrino_PhaseCloak_StatusIcon.png", "Phase Ring", "Venting hard flux into p-space", false);
                Global.getCombatEngine().maintainStatusForPlayerShip(id+2,
                        "graphics/neut/icons/hullsys/neutrino_PhaseCloak_StatusIcon.png", "Phase Ring", "Ship speed reduced", true);
            }
        } else if (!ship.getPhaseCloak().isCoolingDown() && currentFPS > idleFPS) {
            float setFPS = currentFPS - deltaFPS * amount;
            if (setFPS < idleFPS) {
                setFPS = idleFPS;
            }
            anime.setFrameRate(setFPS);
            weapon.getSprite().setColor(color);
        }
    }
}
